'use strict';

angular.module('distribution_sales_model', ['configuration_model'])
    .factory('Distribution', ['$http', '$rootScope', 'Configuration', function($http, $rootScope, Configuration){
        function Distribution(data){
            this.setData(data);
        }

        Distribution.prototype = {
            setData: function(data){
                angular.extend(this, data);
            }
            ,save: function(callback){
                var scope = this;
                $http.post(Configuration.urlDistributionSales, this)
                    .success(function(data){
                        callback(data);
                    })
                    .error(function(data){
                    })
                ;
            }
        }

        return Distribution;
    }])
    .factory('DistributionSalesList', ['$http', '$q', 'Configuration', 'Distribution', function($http, $q, Configuration, Distribution){
        var DistributionSalesList = {
            _isLoadedData: false
            ,_list: []
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this._list;
                }

                var defer = $q.defer();
                var scope = this;

                $http.get(Configuration.urlDistributionSales)
                    .success(function(data){
                        scope._list = [];
                        data.forEach(function(distributionData){
                            scope._list.push(new Distribution(distributionData));
                        });
                        scope._isLoadedData = true;
                        defer.resolve(scope._list);
                    })
                    .error(function(data){
                        defer.reject();
                    })
                ;

                return defer.promise;
            }
            ,getSumPercent: function(){
                var sum = 0;
                if(this._list.length == 0){
                    sum = 100;
                }
                this._list.forEach(function(Distribution){
                    if(Distribution.value) {
                        sum += parseFloat(Distribution.value);
                    }
                });
                return sum;
            }
            ,save: function(callback){
                var scope = this;
                $http.post(Configuration.urlDistributionSales, this)
                    .success(function(data){
                        callback(data);
                    })
                    .error(function(data){
                    })
                ;
            }

        };

        return DistributionSalesList;
    }])
;